
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_BloodTestType : BaseTest 
	{
		
		private DataTable _dtBloodTestType;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtBloodTestType = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodTestType WHERE OrderableTestid IS NOT NULL", true);

				this.RefreshData = false;
			}
			
		}

		[Test]
		public void GetBloodTestTypes_Pass()
		{
			DataTable dtTest = DAL.BloodTestType.GetBloodTestTypes(this._dtBloodTestType.Rows[0][TABLES.BloodTestType.OrderableTestId].ToString());

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestTypeId), TABLES.BloodTestType.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), TABLES.BloodTestType.BloodTestName);
		}

		[Test]
		public void GetBloodTestTypes_Fail()
		{
			DataTable dtTest = DAL.BloodTestType.GetBloodTestTypes(string.Empty);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodTestType_Pass()
		{
			DataTable dtTest = DAL.BloodTestType.GetBloodTestType((int)this._dtBloodTestType.Rows[0][TABLES.BloodTestType.BloodTestTypeId]);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(10, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestTypeId), TABLES.BloodTestType.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), TABLES.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.OrderableTestId), TABLES.BloodTestType.OrderableTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.TestedWith), TABLES.BloodTestType.TestedWith);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.Phase), TABLES.BloodTestType.Phase);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.ReportableTestId), TABLES.BloodTestType.ReportableTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.SortColumn), TABLES.BloodTestType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.LastUpdateUser), TABLES.BloodTestType.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.LastUpdateDate), TABLES.BloodTestType.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.RowVersion), TABLES.BloodTestType.RowVersion);
		}

		[Test]
		public void GetBloodTestType_Fail()
		{
			DataTable dtTest = DAL.BloodTestType.GetBloodTestType(int.MinValue);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}
	}
}

#endif




